local assets =
{
	Asset("ANIM", "anim/firestone.zip"),
}

local prefabs =
{
    "sunmine",
	"rocks",
	"icemerm",
}    

SetSharedLootTable( 'firestone',
{
	{'rocks',   1.0},
	{'rocks',   1.0},	
    {'sunmine',   1.00},
    {'sunmine',   1.00},
	{'flint',   1.0},
	{'sunmine',   0.66},
	{'firemine',   0.33},
})
local function baserock_fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	
	local light = inst.entity:AddLight()
    inst.Light:Enable(true)
	inst.Light:SetRadius(1.5)
    inst.Light:SetFalloff(.5)
    inst.Light:SetIntensity(.8)
    inst.Light:SetColour(32/255,229/255,153/255)
	
	MakeObstaclePhysics(inst, 1.)
	inst:AddComponent("lootdropper") 
	inst:AddComponent("workable")
	inst.components.workable:SetWorkAction(ACTIONS.MINE)
	inst.components.workable:SetWorkLeft(18)

	inst.components.workable:SetOnWorkCallback(
		function(inst, worker, workleft)
			local pt = Point(inst.Transform:GetWorldPosition())
			if workleft <= 0 then
				inst.components.lootdropper:DropLoot(pt)
				inst:Remove()
			else
				
				
				if workleft < TUNING.ROCKS_MINE*(2/6) then
					inst.AnimState:PlayAnimation("low")
				elseif workleft < TUNING.ROCKS_MINE*(5.5/6) then
					inst.AnimState:PlayAnimation("med")
				else
					inst.AnimState:PlayAnimation("idle")
				end
			end
		end)          
	return inst
end


local function fn()
	local inst = baserock_fn()
	inst.AnimState:SetBank("firestone")
	inst.AnimState:SetBuild("firestone")
	inst.AnimState:PlayAnimation("idle")
	inst:AddComponent("inspectable")
	 if not TheWorld.ismastersim then
        return inst
    end
	 inst.components.lootdropper:SetChanceLootTable('firestone')
	return inst
end


return Prefab("firestone", fn, assets, prefabs)